package gov.va.med.mhv.calendar.converter;

import java.util.ArrayList;
import java.util.List;

import org.springframework.core.convert.converter.Converter;

import gov.va.med.mhv.calendar.dto.CalendarCategoryDTO;
import gov.va.med.mhv.calendar.model.CalendarCategory;

public class CalendarCategoryConverter implements Converter<CalendarCategory, CalendarCategoryDTO> {

	@Override
	public CalendarCategoryDTO convert(CalendarCategory source) {
		CalendarCategoryDTO target = new CalendarCategoryDTO();
		
		target.setCalendarCategoryId(source.getCalendarCategoryId());
		target.setDeleted(source.getDeleted());
		target.setCategoryName(source.getCategoryName());
		
		return target;
	}

	public CalendarCategory convert(CalendarCategoryDTO source) {
		CalendarCategory target = new CalendarCategory();
		
		target.setCalendarCategoryId(source.getCalendarCategoryId());
		target.setDeleted(source.getDeleted());
		target.setCategoryName(source.getCategoryName());
		
		return target;
	}
	
	
	public List<CalendarCategoryDTO> convert(List<CalendarCategory> source) {
		List <CalendarCategoryDTO> calendarCategoryDto= null;
		if(null !=source) {
			calendarCategoryDto = new ArrayList<CalendarCategoryDTO>();

			for (CalendarCategory calendarCategory: source) {
				calendarCategoryDto.add(this.convert(calendarCategory));
			}

		}

		return calendarCategoryDto;
	}

}
